# Documentación del Sistema PDV

Este archivo describe la estructura y funcionamiento del sistema PDV y se actualiza con cada hito.

## Hito 1 — Base del sistema

En la primera versión se implementó la base del sistema con:

* Asistente de instalación para crear las tablas iniciales (`users` y `settings`), guardar las credenciales de la base de datos y generar el archivo `config.php`.
* Creación de un usuario **SuperAdmin** con privilegios completos.
* Autenticación mediante usuario y contraseña, con sesión segura (`login.php` / `logout.php`).
* Diseño de la interfaz con barra lateral y superior. Se incluyeron páginas de sección vacías para Usuarios, Roles, Cajas, Configuraciones, Punto de Venta y Estadísticas.
* Control básico de acceso: solo los usuarios logueados pueden acceder a las secciones.

## Hito 2 — Gestión de usuarios, roles y permisos

En este hito se añade el control profesional de acceso mediante la gestión de usuarios y roles:

1. **Tablas y estructuras nuevas**:
   * `roles`: almacena los roles disponibles (nombre y descripción).
   * `role_permissions`: define los permisos de cada rol sobre los módulos (`dashboard`, `users`, `roles`, `boxes`, `settings`, `pos` y `stats`) y acciones (`view`, `create`, `edit`, `delete`).
   * Se añade la columna `role_id` a la tabla `users` para vincular cada usuario con un rol. Se mantiene la columna `role` original para compatibilidad, pero ahora se utiliza `role_id`.

2. **Funciones auxiliares nuevas**:
   * `ensureRoleTables()`: crea las tablas `roles` y `role_permissions` si no existen, añade `role_id` a `users` y, en caso necesario, crea el rol **SuperAdmin** con todos los permisos y lo asigna a los usuarios marcados como superadmin.
   * Funciones CRUD para roles (`getRoles()`, `getRoleById()`, `createRole()`, `updateRole()`, `deleteRole()`) y gestión de permisos.
   * Funciones CRUD para usuarios (`getUsers()`, `createUser()`, `updateUser()`, `deleteUser()`) y asignación de rol mediante `role_id`.
   * `hasPermission()` y `requirePermission()` para comprobar y hacer cumplir los permisos de cada usuario sobre las diferentes secciones.

3. **Páginas actualizadas**:
   * **roles.php**: permite listar, crear, editar y eliminar roles. Para cada rol se pueden definir permisos granulares mediante una tabla de módulos y acciones. No se permite eliminar ni modificar el rol `SuperAdmin`.
   * **users.php**: permite listar, crear, editar y eliminar usuarios. Al crear o editar se asigna un rol existente. La contraseña solo se cambia si se indica.
   * Las secciones muestran u ocultan los menús según los permisos del usuario actual.

4. **Control de acceso real**:
   * Los métodos `hasPermission()` y `requirePermission()` aseguran que un usuario sin permiso no pueda acceder a una URL protegida, incluso si intenta entrar manualmente.
   * Los permisos se aplican a los módulos mencionados: `dashboard`, `users`, `roles`, `boxes`, `settings`, `pos` y `stats`.

Con este hito, el sistema ahora permite gestionar usuarios y roles de manera profesional, asignando permisos de forma granular y protegiendo las rutas de acceso directo.