# Documentación del Sistema PDV

Este archivo describe la estructura y funcionamiento del sistema PDV y se actualiza con cada hito.

## Hito 1 — Base del sistema

En la primera versión se implementó la base del sistema con:

* Asistente de instalación para crear las tablas iniciales (`users` y `settings`), guardar las credenciales de la base de datos y generar el archivo `config.php`.
* Creación de un usuario **SuperAdmin** con privilegios completos.
* Autenticación mediante usuario y contraseña, con sesión segura (`login.php` / `logout.php`).
* Diseño de la interfaz con barra lateral y superior. Se incluyeron páginas de sección vacías para Usuarios, Roles, Cajas, Configuraciones, Punto de Venta y Estadísticas.
* Control básico de acceso: solo los usuarios logueados pueden acceder a las secciones.

## Hito 2 — Gestión de usuarios, roles y permisos

En este hito se añade el control profesional de acceso mediante la gestión de usuarios y roles:

1. **Tablas y estructuras nuevas**:
   * `roles`: almacena los roles disponibles (nombre y descripción).
   * `role_permissions`: define los permisos de cada rol sobre los módulos (`dashboard`, `users`, `roles`, `boxes`, `settings`, `pos` y `stats`) y acciones (`view`, `create`, `edit`, `delete`).
   * Se añade la columna `role_id` a la tabla `users` para vincular cada usuario con un rol. Se mantiene la columna `role` original para compatibilidad, pero ahora se utiliza `role_id`.

2. **Funciones auxiliares nuevas**:
   * `ensureRoleTables()`: crea las tablas `roles` y `role_permissions` si no existen, añade `role_id` a `users` y, en caso necesario, crea el rol **SuperAdmin** con todos los permisos y lo asigna a los usuarios marcados como superadmin.
   * Funciones CRUD para roles (`getRoles()`, `getRoleById()`, `createRole()`, `updateRole()`, `deleteRole()`) y gestión de permisos.
   * Funciones CRUD para usuarios (`getUsers()`, `createUser()`, `updateUser()`, `deleteUser()`) y asignación de rol mediante `role_id`.
   * `hasPermission()` y `requirePermission()` para comprobar y hacer cumplir los permisos de cada usuario sobre las diferentes secciones.

3. **Páginas actualizadas**:
   * **roles.php**: permite listar, crear, editar y eliminar roles. Para cada rol se pueden definir permisos granulares mediante una tabla de módulos y acciones. No se permite eliminar ni modificar el rol `SuperAdmin`.
   * **users.php**: permite listar, crear, editar y eliminar usuarios. Al crear o editar se asigna un rol existente. La contraseña solo se cambia si se indica.
   * Las secciones muestran u ocultan los menús según los permisos del usuario actual.

4. **Control de acceso real**:
   * Los métodos `hasPermission()` y `requirePermission()` aseguran que un usuario sin permiso no pueda acceder a una URL protegida, incluso si intenta entrar manualmente.
   * Los permisos se aplican a los módulos mencionados: `dashboard`, `users`, `roles`, `boxes`, `settings`, `pos` y `stats`.

Con este hito, el sistema ahora permite gestionar usuarios y roles de manera profesional, asignando permisos de forma granular y protegiendo las rutas de acceso directo.

## Hito 3 — Cajas y sesiones de caja, rediseño de interfaz

En el tercer hito se añadió el control contable básico y se mejoró significativamente el aspecto visual de la aplicación para acercarlo a las capturas de referencia. Los cambios principales son:

1. **Gestión de cajas y sesiones**:
   * Se implementó la entidad **caja** (`boxes`) con sus operaciones CRUD: crear, listar, editar y eliminar. Una caja solo puede eliminarse si no tiene una sesión abierta.
   * Se añadió la tabla **cash_sessions** para llevar el control de las sesiones de caja. Cada sesión almacena el usuario que la abre, la fecha/hora de apertura, el monto inicial, la fecha/hora de cierre, el usuario que la cierra, el monto final y la diferencia.
   * La tabla **cash_movements** registra cada movimiento de ingreso o retiro durante una sesión, guardando tipo, monto, descripción, usuario y fecha.
   * Desde la página de cajas se puede abrir una sesión indicando el monto inicial, registrar movimientos de ingreso o retiro, visualizar un resumen de la sesión (monto inicial, ingresos, retiros y saldo esperado) y cerrar la caja registrando el monto final contado. El sistema calcula la diferencia entre el saldo esperado y el efectivo contado.
   * El historial de sesiones permite consultar sesiones previas de cada caja, con enlace a un detalle donde se muestran los movimientos y el resumen de la diferencia.
   * Se añadió una llamada a `ensureBoxTables()` en el instalador para crear las tablas necesarias al momento de la instalación.

2. **Rediseño completo de la interfaz**:
   * Se creó un archivo `assets/css/style.css` con variables CSS y estilos inspirados en la interfaz de PrestaShop, usando una paleta de colores moderna (azul principal) y tipografías más legibles.
   * Se reestructuró el `layout.php` para incluir iconos (Font Awesome) y una barra lateral oscura con enlaces activos bien identificados. La barra superior ahora es clara y ligera, mostrando el nombre del usuario y un botón que colapsa la sidebar en dispositivos móviles.
   * Todos los listados y formularios se presentan dentro de tarjetas Bootstrap con sombras sutiles. Las tablas utilizan estilos striped y bordered para mejorar la legibilidad.
   * Se añadió un pequeño script (`assets/js/script.js`) para alternar la visibilidad de la sidebar en pantallas pequeñas.
   * La página de inicio de sesión se rediseñó para que coincida con la estética general: un formulario centrado en pantalla dentro de una tarjeta, con icono, uso de variables de color y un botón que destaca.

3. **Integración con roles y permisos**:
   * Las operaciones de cajas respetan los permisos definidos en el hito 2. Solo los usuarios con permiso de crear/editar/eliminar cajas pueden realizar esas acciones; los que solo tienen permiso de vista pueden consultar los resúmenes e historiales, pero no abrir ni cerrar caja.

Con estas mejoras, el sistema ofrece un control contable básico que impide tener más de una sesión abierta por caja, calcula correctamente el saldo esperado y guarda el historial de movimientos. Además, la interfaz es más agradable, usable y responsive, acercándose a las capturas proporcionadas.

## Hito 4 — Configuraciones generales

En esta entrega se habilita la parametrización del sistema a través de la sección **Configuraciones**, permitiendo a los usuarios con permisos adecuados gestionar los medios de pago y la apariencia de los tickets de venta. Los principales añadidos son:

1. **Medios de pago**:
   * Se introduce la tabla `payment_methods` en la base de datos, que almacena el nombre del medio de pago, si está activo o no, y el porcentaje de descuento que aplica ese medio. Esta tabla se crea automáticamente tanto al instalar el sistema como al acceder a la sección de configuraciones.
   * La interfaz permite listar todos los medios de pago, crear nuevos, editar o eliminar los existentes. Para cada medio se pueden establecer:
     * **Nombre**: identificador legible (ej. Efectivo, Tarjeta, Transferencia, etc.).
     * **Activo**: habilita o deshabilita el medio. Los medios desactivados no se mostrarán en el Punto de Venta (hito 5).
     * **% de descuento**: porcentaje que se aplicará al total cuando se utilice ese medio; este valor se guarda y se utilizará en la pantalla de PDV.
   * Las acciones de creación, edición y eliminación están protegidas por los permisos `settings:create`, `settings:edit` y `settings:delete` respectivamente.

2. **Configuración de tickets**:
   * Se añaden nuevos campos en la tabla `settings` para almacenar el **encabezado**, **pie** y **logo** del ticket. Estos valores se gestionan desde la misma página de configuraciones.
   * El usuario puede escribir textos personalizados para el encabezado y pie del ticket y subir una imagen (PNG, JPEG o WebP) como logo. El sistema guarda la ruta del logo en la carpeta `uploads/` y la utiliza en la impresión.
   * Incluye un botón **“Impresión de prueba”** que abre una vista (`ticket_test.php`) mostrando un ticket ficticio con la configuración actual. Esta página invoca automáticamente el cuadro de diálogo de impresión del navegador para facilitar una prueba rápida.

3. **Mejoras generales**:
   * Se amplía el instalador para que cree la tabla `payment_methods` junto con el resto de tablas, asegurando que las configuraciones están disponibles desde la primera ejecución.
   * La página `settings.php` se restructuró con tarjetas (cards) claramente separadas para cada área de configuración. Se mantiene la coherencia de diseño con el resto de la aplicación.
   * Se actualiza la documentación para incluir instrucciones sobre cómo añadir y administrar medios de pago y cómo personalizar la apariencia de los tickets.

Con el Hito 4, el sistema es capaz de adaptarse a diferentes formas de cobro, aplicando descuentos de forma centralizada y permitiendo personalizar la imagen de los tickets que recibirán los clientes. Estas configuraciones son la base para integrar el Punto de Venta en el próximo hito.