<?php
require_once __DIR__ . '/includes/functions.php';

/**
 * Renderiza la cabecera y la barra de navegación.
 *
 * @param string $title
 * @param string $active Nombre del menú activo
 */
function renderHeader(string $title = '', string $active = ''): void
{
    $user = currentUser();
    $username = $user['username'] ?? '';
    ?>
    <!DOCTYPE html>
    <html lang="es">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title><?php echo escape($title); ?> - PDV</title>
        <!-- Bootstrap CSS -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-2ZY5sxzobS//s3m4W9Pi1s2ynG1iXGk4MReeQ0bGAP7zRvH+6zCuN6E6a2hZIlK" crossorigin="anonymous">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-p+bsAoI8zwlFuvUihh1f5RduCMsZ/HXXIQK5vCk1vZ1tcHTTX3e8DqRLVQjaxctq6nxsVXniPjWh9sC/WZE/lQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
        <!-- Estilos personalizados -->
        <link rel="stylesheet" href="<?php echo baseUrl('assets/css/style.css'); ?>">
    </head>
    <body>
    <!-- Topbar -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white fixed-top">
        <div class="container-fluid">
            <a class="navbar-brand" href="<?php echo baseUrl('index.php'); ?>">PDV</a>
            <button class="btn btn-link d-lg-none" id="toggleSidebar"><i class="fas fa-bars fa-lg"></i></button>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item d-flex align-items-center me-3">
                        <i class="fas fa-user-circle me-1"></i>
                        <span class="nav-link p-0">Bienvenido, <?php echo escape($username); ?></span>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo baseUrl('logout.php'); ?>"><i class="fas fa-sign-out-alt me-1"></i> Cerrar sesión</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <!-- Sidebar -->
    <div class="sidebar">
        <?php if (hasPermission('dashboard', 'view')): ?>
            <a href="<?php echo baseUrl('dashboard.php'); ?>"<?php echo ($active === 'dashboard') ? ' class="active"' : ''; ?>>
                <span class="icon"><i class="fas fa-home"></i></span> Inicio
            </a>
        <?php endif; ?>
        <?php if (hasPermission('users', 'view')): ?>
            <a href="<?php echo baseUrl('users.php'); ?>"<?php echo ($active === 'users') ? ' class="active"' : ''; ?>>
                <span class="icon"><i class="fas fa-users"></i></span> Usuarios
            </a>
        <?php endif; ?>
        <?php if (hasPermission('roles', 'view')): ?>
            <a href="<?php echo baseUrl('roles.php'); ?>"<?php echo ($active === 'roles') ? ' class="active"' : ''; ?>>
                <span class="icon"><i class="fas fa-user-tag"></i></span> Roles
            </a>
        <?php endif; ?>
        <?php if (hasPermission('boxes', 'view')): ?>
            <a href="<?php echo baseUrl('boxes.php'); ?>"<?php echo ($active === 'boxes') ? ' class="active"' : ''; ?>>
                <span class="icon"><i class="fas fa-cash-register"></i></span> Cajas
            </a>
        <?php endif; ?>
        <?php if (hasPermission('settings', 'view')): ?>
            <a href="<?php echo baseUrl('settings.php'); ?>"<?php echo ($active === 'settings') ? ' class="active"' : ''; ?>>
                <span class="icon"><i class="fas fa-cogs"></i></span> Configuraciones
            </a>
        <?php endif; ?>
        <?php if (hasPermission('pos', 'view')): ?>
            <a href="<?php echo baseUrl('pos.php'); ?>"<?php echo ($active === 'pos') ? ' class="active"' : ''; ?>>
                <span class="icon"><i class="fas fa-shopping-cart"></i></span> Punto de Venta
            </a>
        <?php endif; ?>
        <?php if (hasPermission('stats', 'view')): ?>
            <a href="<?php echo baseUrl('stats.php'); ?>"<?php echo ($active === 'stats') ? ' class="active"' : ''; ?>>
                <span class="icon"><i class="fas fa-chart-line"></i></span> Estadísticas
            </a>
        <?php endif; ?>
    </div>
    <!-- Contenido principal -->
    <div class="content">
    <?php
}

/**
 * Renderiza el pie de página y scripts necesarios.
 */
function renderFooter(): void
{
    ?>
    </div> <!-- /.content -->
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-qo1NK9vdN2AyJEaCmxEtdlJ6dNVY4s9dL7LTrO2TV4QZk2aIy08eRUKqT1syeZye" crossorigin="anonymous"></script>
    <!-- Script personalizado -->
    <script src="<?php echo baseUrl('assets/js/script.js'); ?>"></script>
    </body>
    </html>
    <?php
}