<?php
/*
 * Vista para imprimir un ticket de prueba.
 *
 * Muestra el encabezado, logo y pie configurados en el sistema, junto con un contenido de ejemplo.
 */
require_once __DIR__ . '/includes/functions.php';

// Cargar configuración de tickets
$pdo = getPDO();
$header = getSetting($pdo, 'ticket_header') ?? '';
$footer = getSetting($pdo, 'ticket_footer') ?? '';
$logo   = getSetting($pdo, 'ticket_logo') ?? '';

?><!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Ticket de prueba</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #fff;
            color: #000;
        }
        .ticket {
            width: 80mm;
            margin: 0 auto;
            text-align: center;
        }
        .ticket img {
            max-width: 100%;
            height: auto;
            margin-bottom: 10px;
        }
        hr {
            border: none;
            border-top: 1px dashed #000;
            margin: 10px 0;
        }
    </style>
</head>
<body onload="window.print()">
<div class="ticket">
    <?php if ($logo): ?>
        <img src="<?php echo baseUrl($logo); ?>" alt="Logo">
    <?php endif; ?>
    <?php if ($header): ?>
        <div><?php echo nl2br(escape($header)); ?></div>
    <?php endif; ?>
    <hr>
    <div style="text-align:left;">
        <p><strong>Producto de ejemplo</strong></p>
        <p>Cantidad: 1&nbsp;&nbsp;&nbsp;Precio: 10,00&nbsp;€</p>
        <p><strong>Total: 10,00&nbsp;€</strong></p>
    </div>
    <hr>
    <?php if ($footer): ?>
        <div><?php echo nl2br(escape($footer)); ?></div>
    <?php endif; ?>
    <p style="margin-top:10px; font-size:12px;">*** Fin del ticket de prueba ***</p>
</div>
</body>
</html>