# Sistema de Punto de Venta (PDV)

Este proyecto es un sistema de punto de venta (PDV) desarrollado en PHP que se integra con PrestaShop 8.1.6. Está diseñado para instalarse en un servidor web y proporcionar una interfaz de administración para gestionar ventas de manera eficiente.

## Descripción

El proyecto se estructura en varios hitos que definen la funcionalidad a implementar de forma incremental. En el **Hito 1** se establece la base del sistema, incluyendo un instalador, la configuración de bases de datos y un usuario SuperAdmin. Este hito proporciona las bases necesarias para los hitos posteriores, como la gestión de usuarios, cajas, configuraciones generales, punto de venta, integración con PrestaShop, creación de pedidos y estadísticas.

## Hito 1 — Base del sistema

En esta primera fase se implementan los siguientes componentes básicos:

* **Instalador** (`/install`): Asistente que solicita datos de conexión a las bases de datos (PDV y PrestaShop), crea las tablas necesarias y genera el archivo de configuración seguro.
* **Gestión de sesión**: Inicio y cierre de sesión para un usuario SuperAdmin.
* **Layout global**: Navegación con barra lateral y superior que permite acceder a las secciones principales (usuarios, roles, cajas, configuraciones, punto de venta, estadísticas). Por ahora las secciones están vacías, pero sirven de estructura para los hitos futuros.
* **Seguridad**: Almacén seguro de credenciales, contraseñas hasheadas y control de acceso básico.

## Estructura de carpetas

```
pos/
├── install/             # Asistente de instalación
│   └── index.php
├── includes/            # Funciones reutilizables y plantilla de configuración
│   ├── config.sample.php
│   └── functions.php
├── index.php            # Front controller que redirige a dashboard.php
├── login.php            # Inicio de sesión
├── logout.php           # Cierre de sesión
├── dashboard.php        # Página de inicio una vez logueado
├── layout.php           # Plantilla de diseño (sidebar + topbar)
└── README.md            # Información del proyecto
```

Para más información sobre los hitos y la evolución del proyecto, consulte la documentación asociada.