# Documentación del Sistema PDV

Este archivo describe la estructura y funcionamiento del sistema PDV y se actualiza con cada hito.

## Hito 1 — Base del sistema

En la primera versión se implementó la base del sistema con:

* Asistente de instalación para crear las tablas iniciales (`users` y `settings`), guardar las credenciales de la base de datos y generar el archivo `config.php`.
* Creación de un usuario **SuperAdmin** con privilegios completos.
* Autenticación mediante usuario y contraseña, con sesión segura (`login.php` / `logout.php`).
* Diseño de la interfaz con barra lateral y superior. Se incluyeron páginas de sección vacías para Usuarios, Roles, Cajas, Configuraciones, Punto de Venta y Estadísticas.
* Control básico de acceso: solo los usuarios logueados pueden acceder a las secciones.

## Hito 2 — Gestión de usuarios, roles y permisos

En este hito se añade el control profesional de acceso mediante la gestión de usuarios y roles:

1. **Tablas y estructuras nuevas**:
   * `roles`: almacena los roles disponibles (nombre y descripción).
   * `role_permissions`: define los permisos de cada rol sobre los módulos (`dashboard`, `users`, `roles`, `boxes`, `settings`, `pos` y `stats`) y acciones (`view`, `create`, `edit`, `delete`).
   * Se añade la columna `role_id` a la tabla `users` para vincular cada usuario con un rol. Se mantiene la columna `role` original para compatibilidad, pero ahora se utiliza `role_id`.

2. **Funciones auxiliares nuevas**:
   * `ensureRoleTables()`: crea las tablas `roles` y `role_permissions` si no existen, añade `role_id` a `users` y, en caso necesario, crea el rol **SuperAdmin** con todos los permisos y lo asigna a los usuarios marcados como superadmin.
   * Funciones CRUD para roles (`getRoles()`, `getRoleById()`, `createRole()`, `updateRole()`, `deleteRole()`) y gestión de permisos.
   * Funciones CRUD para usuarios (`getUsers()`, `createUser()`, `updateUser()`, `deleteUser()`) y asignación de rol mediante `role_id`.
   * `hasPermission()` y `requirePermission()` para comprobar y hacer cumplir los permisos de cada usuario sobre las diferentes secciones.

3. **Páginas actualizadas**:
   * **roles.php**: permite listar, crear, editar y eliminar roles. Para cada rol se pueden definir permisos granulares mediante una tabla de módulos y acciones. No se permite eliminar ni modificar el rol `SuperAdmin`.
   * **users.php**: permite listar, crear, editar y eliminar usuarios. Al crear o editar se asigna un rol existente. La contraseña solo se cambia si se indica.
   * Las secciones muestran u ocultan los menús según los permisos del usuario actual.

4. **Control de acceso real**:
   * Los métodos `hasPermission()` y `requirePermission()` aseguran que un usuario sin permiso no pueda acceder a una URL protegida, incluso si intenta entrar manualmente.
   * Los permisos se aplican a los módulos mencionados: `dashboard`, `users`, `roles`, `boxes`, `settings`, `pos` y `stats`.

Con este hito, el sistema ahora permite gestionar usuarios y roles de manera profesional, asignando permisos de forma granular y protegiendo las rutas de acceso directo.

## Hito 3 — Cajas y sesiones de caja, rediseño de interfaz

En el tercer hito se añadió el control contable básico y se mejoró significativamente el aspecto visual de la aplicación para acercarlo a las capturas de referencia. Los cambios principales son:

1. **Gestión de cajas y sesiones**:
   * Se implementó la entidad **caja** (`boxes`) con sus operaciones CRUD: crear, listar, editar y eliminar. Una caja solo puede eliminarse si no tiene una sesión abierta.
   * Se añadió la tabla **cash_sessions** para llevar el control de las sesiones de caja. Cada sesión almacena el usuario que la abre, la fecha/hora de apertura, el monto inicial, la fecha/hora de cierre, el usuario que la cierra, el monto final y la diferencia.
   * La tabla **cash_movements** registra cada movimiento de ingreso o retiro durante una sesión, guardando tipo, monto, descripción, usuario y fecha.
   * Desde la página de cajas se puede abrir una sesión indicando el monto inicial, registrar movimientos de ingreso o retiro, visualizar un resumen de la sesión (monto inicial, ingresos, retiros y saldo esperado) y cerrar la caja registrando el monto final contado. El sistema calcula la diferencia entre el saldo esperado y el efectivo contado.
   * El historial de sesiones permite consultar sesiones previas de cada caja, con enlace a un detalle donde se muestran los movimientos y el resumen de la diferencia.
   * Se añadió una llamada a `ensureBoxTables()` en el instalador para crear las tablas necesarias al momento de la instalación.

2. **Rediseño completo de la interfaz**:
   * Se creó un archivo `assets/css/style.css` con variables CSS y estilos inspirados en la interfaz de PrestaShop, usando una paleta de colores moderna (azul principal) y tipografías más legibles.
   * Se reestructuró el `layout.php` para incluir iconos (Font Awesome) y una barra lateral oscura con enlaces activos bien identificados. La barra superior ahora es clara y ligera, mostrando el nombre del usuario y un botón que colapsa la sidebar en dispositivos móviles.
   * Todos los listados y formularios se presentan dentro de tarjetas Bootstrap con sombras sutiles. Las tablas utilizan estilos striped y bordered para mejorar la legibilidad.
   * Se añadió un pequeño script (`assets/js/script.js`) para alternar la visibilidad de la sidebar en pantallas pequeñas.
   * La página de inicio de sesión se rediseñó para que coincida con la estética general: un formulario centrado en pantalla dentro de una tarjeta, con icono, uso de variables de color y un botón que destaca.

3. **Integración con roles y permisos**:
   * Las operaciones de cajas respetan los permisos definidos en el hito 2. Solo los usuarios con permiso de crear/editar/eliminar cajas pueden realizar esas acciones; los que solo tienen permiso de vista pueden consultar los resúmenes e historiales, pero no abrir ni cerrar caja.

Con estas mejoras, el sistema ofrece un control contable básico que impide tener más de una sesión abierta por caja, calcula correctamente el saldo esperado y guarda el historial de movimientos. Además, la interfaz es más agradable, usable y responsive, acercándose a las capturas proporcionadas.

## Hito 4 — Configuraciones generales

En esta entrega se habilita la parametrización del sistema a través de la sección **Configuraciones**, permitiendo a los usuarios con permisos adecuados gestionar los medios de pago y la apariencia de los tickets de venta. Los principales añadidos son:

1. **Medios de pago**:
   * Se introduce la tabla `payment_methods` en la base de datos, que almacena el nombre del medio de pago, si está activo o no, y el porcentaje de descuento que aplica ese medio. Esta tabla se crea automáticamente tanto al instalar el sistema como al acceder a la sección de configuraciones.
   * La interfaz permite listar todos los medios de pago, crear nuevos, editar o eliminar los existentes. Para cada medio se pueden establecer:
     * **Nombre**: identificador legible (ej. Efectivo, Tarjeta, Transferencia, etc.).
     * **Activo**: habilita o deshabilita el medio. Los medios desactivados no se mostrarán en el Punto de Venta (hito 5).
     * **% de descuento**: porcentaje que se aplicará al total cuando se utilice ese medio; este valor se guarda y se utilizará en la pantalla de PDV.
   * Las acciones de creación, edición y eliminación están protegidas por los permisos `settings:create`, `settings:edit` y `settings:delete` respectivamente.

2. **Configuración de tickets**:
   * Se añaden nuevos campos en la tabla `settings` para almacenar el **encabezado**, **pie** y **logo** del ticket. Estos valores se gestionan desde la misma página de configuraciones.
   * El usuario puede escribir textos personalizados para el encabezado y pie del ticket y subir una imagen (PNG, JPEG o WebP) como logo. El sistema guarda la ruta del logo en la carpeta `uploads/` y la utiliza en la impresión.
   * Incluye un botón **“Impresión de prueba”** que abre una vista (`ticket_test.php`) mostrando un ticket ficticio con la configuración actual. Esta página invoca automáticamente el cuadro de diálogo de impresión del navegador para facilitar una prueba rápida.

3. **Mejoras generales**:
   * Se amplía el instalador para que cree la tabla `payment_methods` junto con el resto de tablas, asegurando que las configuraciones están disponibles desde la primera ejecución.
   * La página `settings.php` se restructuró con tarjetas (cards) claramente separadas para cada área de configuración. Se mantiene la coherencia de diseño con el resto de la aplicación.
   * Se actualiza la documentación para incluir instrucciones sobre cómo añadir y administrar medios de pago y cómo personalizar la apariencia de los tickets.

Con el Hito 4, el sistema es capaz de adaptarse a diferentes formas de cobro, aplicando descuentos de forma centralizada y permitiendo personalizar la imagen de los tickets que recibirán los clientes. Estas configuraciones son la base para integrar el Punto de Venta en el próximo hito.

## Hito 5 — Punto de Venta (UI + carrito local)

El objetivo del quinto hito es ofrecer una experiencia de venta fluida y responsiva para los usuarios del PDV sin crear aún pedidos reales ni modificar el stock. Se implementa una pantalla de Punto de Venta que integra búsqueda básica de productos, carrito local y aplicación de descuentos según el medio de pago seleccionado. Los puntos clave son:

1. **Interfaz de productos**:
   * Se introduce una nueva página `pos.php` que muestra un listado de productos obtenidos de la base de datos de PrestaShop. La conexión a PrestaShop se realiza mediante la función `getPsPDO()`, que lee las credenciales guardadas durante la instalación.
   * Los productos se recuperan mediante `getProducts()`, que realiza una consulta sencilla a las tablas `product` y `product_lang` filtrando opcionalmente por nombre o referencia y limitando los resultados para no sobrecargar la interfaz.
   * Se incluye un campo de búsqueda; el usuario puede filtrar los productos por nombre o referencia. Los resultados se muestran como tarjetas con el nombre, referencia y precio. Cada tarjeta tiene un botón “Agregar” que suma el producto al carrito.

2. **Carrito de compra local**:
   * El carrito se almacena en la sesión del usuario (`$_SESSION['cart']`), por lo que no modifica el stock ni genera pedidos en PrestaShop.
   * El usuario puede modificar la cantidad de cada producto (con inputs numéricos), eliminar productos o vaciar el carrito por completo. Todo ello está protegido por acciones con confirmación para evitar eliminaciones accidentales.
   * Los totales se calculan en tiempo real: **subtotal**, **descuento** (según el medio de pago) y **total final**.
   * Se permite seleccionar un medio de pago activo desde un desplegable. El porcentaje de descuento configurado para ese medio se aplica sobre el subtotal y se muestra tanto el importe descontado como el total actualizado.
   * El botón **“Finalizar venta (simulado)”** limpia el carrito y muestra un mensaje informativo; la creación real del pedido y el descuento de stock se implementarán en el hito 7.

3. **Conexión a PrestaShop**:
   * Se incorpora la función `getPsPDO()` para establecer una conexión independiente con la base de datos de PrestaShop usando las credenciales almacenadas en `config.php`.
   * Se añaden funciones auxiliares `getProducts()` y `getProductById()` para recuperar productos de manera básica sin necesidad de usar el core de PrestaShop. Estas funciones usan el prefijo configurado y suponen que el idioma con `id_lang = 1` es válido para obtener los nombres.

4. **Diseño y usabilidad**:
   * La pantalla se divide en dos columnas: a la izquierda, los productos con buscador; a la derecha, el carrito y los totales. Todo se presenta en tarjetas y tablas que respetan el estilo general implementado en hitos anteriores.
   * Se mantiene la responsabilidad: en dispositivos pequeños, las tarjetas se adaptan de 1 a 2 productos por fila, y el carrito sigue siendo accesible.
   * Se añaden iconos y colores coherentes con la paleta del proyecto, mejorando la experiencia de usuario.

Con el Hito 5, el sistema ya permite al usuario simular una venta completa: buscar productos reales de PrestaShop, añadirlos a un carrito local, seleccionar un medio de pago con su descuento y calcular el importe total. Este flujo sienta las bases para que, en el hito 6, se integre el core de PrestaShop para validar el stock en tiempo real, y en el hito 7 se generen pedidos reales y se descuente el stock.

## Depuración y gestión de errores (versión vUpdated 1.1)

En la versión vUpdated 1.1 se añade un mecanismo opcional de depuración para facilitar el análisis de errores en ambientes de pruebas:

* **Modo de depuración**: se ha incluido la opción `app.debug` en el archivo `includes/config.php` (generado durante la instalación a partir de `config.sample.php`). Si se establece en `true`, el sistema mostrará los errores de PHP directamente en la interfaz, facilitando la detección de problemas durante el desarrollo o pruebas. Cuando `debug` está desactivado (`false`), los errores no se muestran al usuario final.
* **Registro de errores**: todas las advertencias, errores y excepciones se registran en un archivo ubicado en `pos/logs/error.log`. Este archivo se crea automáticamente si no existe. De este modo, incluso en producción (con `debug` desactivado) es posible consultar el registro para identificar incidencias.
* **Activación**: para activar el modo debug, edite el archivo `includes/config.php` después de la instalación y agregue o modifique la clave:

  ```php
  'app' => [
      'base_url' => 'https://su-dominio.com/pos',
      'secret_key' => 'clave-generada',
      'debug' => true,
  ];
  ```

  Vuelva a cargar la aplicación y los mensajes de error se mostrarán en pantalla. Recuerde desactivar el modo debug (`false`) antes de poner en producción para no exponer información sensible.

Este mecanismo de depuración no altera el flujo de la aplicación, sino que proporciona visibilidad sobre errores que de otra forma podrían ocasionar una página en blanco o un error 500 sin información adicional.

## Hito 6 — Integración con PrestaShop (productos simples y combinaciones)

Este hito añade la sincronización real con PrestaShop 8.1.6 para leer productos simples y sus combinaciones, calcular precios reales y validar el stock en tiempo real. Los aspectos clave son los siguientes:

1. **Lectura unificada de productos y combinaciones**

   * Se introducen las funciones `getProductVariants()` y `getVariant($key)` en `includes/functions.php`. Estas funciones utilizan directamente la base de datos de PrestaShop para obtener tanto los productos simples como todas sus combinaciones.
   * Para cada combinación se generan los siguientes datos: ID del producto, ID de la combinación, nombre completo (nombre del producto + atributos), referencia (de la combinación si existe, si no la del producto), precio final (precio base + impacto de la combinación) y stock disponible (`ps_stock_available.quantity`).
   * Las combinaciones se distinguen de los productos simples mediante una clave única con formato `id_product-id_attribute`. Por ejemplo, `5-0` representa el producto 5 sin combinaciones; `5-12` representa la combinación 12 del producto 5.
   * Los productos que tienen combinaciones ya no se muestran como productos simples para evitar confusión de stock: solo se listan sus combinaciones.

2. **Cálculo de precio**

   * El precio de cada variante se calcula sumando el `price` del producto base (`ps_product.price`) más el `price` de la combinación (`ps_product_attribute.price`), siguiendo la lógica de PrestaShop para el “impacto en el precio”. No se aplican impuestos ni reglas específicas de precios en esta fase.

3. **Validación de stock en tiempo real**

   * El stock de cada variante se obtiene de la tabla `ps_stock_available`. Para combinaciones se toma la fila con `id_product_attribute` correspondiente; para productos simples se utiliza la fila donde `id_product_attribute = 0`.
   * En la interfaz del PDV, se muestra el stock disponible de cada producto/combination. El botón “Agregar” se desactiva cuando el stock es cero, mostrando “Agotado”.
   * Al añadir productos al carrito local, el sistema verifica que la cantidad en carrito no supere el stock disponible. Si se intenta añadir más unidades de las disponibles, se muestra un mensaje de error (“No hay stock suficiente para la cantidad solicitada”).
   * Al actualizar cantidades en el carrito, las cantidades se ajustan automáticamente al máximo permitido por el stock.

4. **Flujo actualizado en `pos.php`**

   * El listado de productos se construye a partir de `getProductVariants()`, que devuelve productos simples y combinaciones ordenados alfabéticamente.
   * Cada tarjeta de producto muestra el nombre, referencia, precio y stock. El formulario de “Agregar” envía una `product_key` que identifica la variante.
   * El carrito local ahora utiliza esa `product_key` como índice. Se conservan los campos `name`, `reference`, `price`, `qty` y `stock` de cada variante.
   * Se añaden mensajes de error parametrizados (por ejemplo, `?error=stock`) que se muestran en la parte superior de la página cuando un producto no tiene stock o la cantidad solicitada supera el disponible.

5. **Motivo del error 500 y prevención**

   * El error 500 que se produjo antes de esta actualización se debía a la redefinición de funciones (por ejemplo, había dos declaraciones de `getPaymentMethodById()`), lo que generaba un error fatal de “cannot redeclare function”. Tras una revisión completa, se eliminaron las funciones duplicadas y se reorganizó el código para centralizar las funciones auxiliares.
   * Además, se añadió un mecanismo de depuración (`app.debug`) que permite mostrar errores y registrarlos en `logs/error.log`, evitando así que un fallo silencioso provoque una página en blanco. Esta funcionalidad ayuda a identificar problemas rápidamente y evita repetir el mismo error.

Con esta integración, el PDV utiliza la base de datos de PrestaShop para ofrecer un listado de productos y combinaciones coherente con el back office, mostrando la cantidad de stock exacta para cada variante. La validación de stock en tiempo real evita que el usuario agregue o actualice cantidades superiores a las disponibles, cumpliendo así los criterios de aceptación del hito 6.

## Hito 7 — Creación de pedido y descuento de stock (versión v1.4)

En este hito se implementa la función crítica de registrar ventas reales en PrestaShop y descontar el stock, cumpliendo con los requisitos del proyecto. Además, se continúa refinando la apariencia del Punto de Venta para ofrecer una experiencia más moderna y adaptada a las capturas de referencia. Los aspectos más destacados son:

1. **Creación de pedidos reales y actualización de stock**
   * Se implementó la función `createSaleAndOrder()` en `includes/functions.php`. Esta función se encarga de:
     * Cargar el núcleo de PrestaShop a partir de la ruta configurada (`prestashop.path`) y obtener el contexto (`Context::getContext()`).
     * Crear un **carrito** de PrestaShop y asignarle un cliente y direcciones por defecto. A cada producto y combinación del carrito local se le añaden las cantidades correspondientes mediante `Cart::updateQty()`.
     * Recuperar el módulo de pago especificado (por ejemplo, `ps_wirepayment`) mediante `Module::getInstanceByName()`. Si no se define `module_name` en el medio de pago, se usa `ps_wirepayment` como módulo genérico.
     * Validar el pedido con `PaymentModule::validateOrder()`, utilizando el estado de pedido por defecto (`PS_OS_PAYMENT`). Esta llamada crea automáticamente el pedido en la base de datos de PrestaShop y actualiza el stock de cada producto/combinación.
     * Registrar la venta en la base de datos del PDV en las tablas `sales` y `sales_items`, guardando los datos relevantes: usuario que realiza la venta, medio de pago, importe total, subtotal, descuento aplicado y el ID del pedido generado en PrestaShop.
     * Devolver el ID de pedido para mostrarlo al usuario.
   * Se añadió la tabla `sales` (ventas) y `sales_items` (detalle de venta) mediante la función `ensureSalesTables()`. Estas tablas se crean automáticamente al instalar el sistema y cuando se ejecuta por primera vez la función de crear venta.

2. **Flujo en la interfaz de PDV**
   * Al pulsar el botón **“Finalizar venta”**, el sistema comprueba que el carrito no está vacío y que se ha seleccionado un medio de pago. Si todo es correcto, se llama a `createSaleAndOrder()` con los datos del carrito y el medio de pago. Tras completar el pedido, el carrito se vacía, el método de pago se reinicia y se muestra un mensaje de éxito con el ID del pedido generado.
   * Si ocurre un error durante la creación del pedido (por ejemplo, por un fallo de conexión o un módulo de pago no configurado), se captura la excepción, se registra en `logs/error.log` y se redirige al usuario con un mensaje de error (`?error=order`).

3. **Mejoras de diseño en el Punto de Venta**
   * Se introdujo un diseño de **tarjetas** para los productos, con iconos de cajas, nombres truncados de forma elegante, referencias, precio y stock visible. Cada tarjeta cuenta con un botón de “Agregar” integrado que se desactiva cuando el stock es cero, mostrando “Agotado”. Este nuevo layout mejora la legibilidad y la experiencia de usuario, acercándose a la estética de la referencia.
   * Se reorganizó el contenido de `pos.php` en dos columnas: a la izquierda el listado de productos en formato grid (responsive), y a la derecha el carrito con los totales y la selección de medio de pago. Las tarjetas utilizan sombreado y transiciones suaves para ofrecer una sensación más moderna.
   * Se actualizaron los estilos en `assets/css/style.css` para las nuevas clases `.product-card`, incluyendo variables CSS para colores, sombras y transiciones. También se definieron estilos para los encabezados de tarjetas (`.card-header`) y se importó la fuente **Poppins** desde Google Fonts en `layout.php` y `login.php`.

4. **Rediseño global en la versión 1.4**

   Inspirándonos en las últimas capturas aportadas por el cliente, se actualizó por completo la estética del sistema para acercarse aún más al aspecto deseado y corregir problemas de visualización que aparecieron al vaciar la caché:

   * **Barra lateral ancha con iconos y etiquetas**: en lugar de una barra estrecha con solo iconos, ahora la barra lateral ocupa 220 px e incluye tanto el icono como el nombre de cada sección. Esto facilita la navegación y proporciona contexto sin tener que usar tooltips. La barra mantiene un fondo claro y resalta la opción activa con un color diferente.
   * **Búsqueda ampliada y acciones rápidas**: la cabecera de `pos.php` combina el título con un campo de búsqueda de mayor altura y un botón de búsqueda. Debajo se muestra una fila de botones de acciones rápidas (Cliente, Descuento, Nota, Producto y Envío) estilizados con iconos y texto, con mayor tamaño y separaciones para mejorar su usabilidad en pantallas táctiles.
   * **Carrito con placeholder visual**: cuando el carrito está vacío se muestra un bloque central con un icono grande de carrito y un mensaje explicativo (“El carrito está vacío. Agrega productos al carrito para comenzar.”). De este modo, la interfaz resulta menos desolada y guía al usuario.
   * **Diseño coherente en listas y tarjetas**: se mantiene el uso de tarjetas para productos y cajas, pero se revisan los márgenes, tamaños de fuente y sombras para que todas las páginas muestren fondos claros, bordes sutiles y tipografías uniformes. Además, el dashboard se reorganiza con tarjetas de métricas y accesos directos para ofrecer una visión más profesional al ingresar al sistema.
   * **Medios de pago desacoplados de PrestaShop**: en esta versión se elimina por completo la vinculación de los medios de pago con los módulos de PrestaShop. El campo “módulo de pago” se suprime de la interfaz y las funciones `createPaymentMethod()` y `updatePaymentMethod()` ahora ignoran cualquier valor de módulo, dejando la columna `module_name` vacía. En el `Punto de Venta` se selecciona un módulo por defecto (`ps_wirepayment`) internamente al crear el pedido real, por lo que el usuario solo gestiona nombre, activación y porcentaje de descuento.
   * **Actualización de recursos**: para evitar problemas de caché, las hojas de estilo se cargan con un parámetro de versión (`?v=1.5`) y se ajustó el script de la barra lateral para desplazarla 220 px al ocultarla en dispositivos móviles.

   Con estas mejoras, el aspecto del PDV se estabiliza y se alinea mejor con las capturas de ejemplo: la navegación es más clara, el buscador y las acciones son más visibles y el carrito transmite su estado de forma gráfica.

5. **Documentación y depuración**
   * El error SQL `Invalid parameter number` que se presentaba al consultar variantes de productos se documentó y solucionó en la versión vUpdated 1.2, usando marcadores de parámetro únicos en las consultas preparadas. Esta corrección se explica al final del hito 6 y se preserva en este hito.
   * Se mantuvo y amplió el mecanismo de depuración opcional (`app.debug`) y el registro de errores en `logs/error.log`. Esto resulta esencial para identificar cualquier incidencia durante la creación de pedidos reales.

Con el Hito 7, el sistema PDV se conecta completamente con PrestaShop para crear pedidos reales y descontar stock, cumpliendo los criterios de aceptación definidos: se usa el core de PrestaShop para validar el pedido (sin consultas manuales de SQL) y se registra la venta en el módulo PDV. Además, la interfaz del Punto de Venta se refina estéticamente para ofrecer una experiencia de uso más agradable y profesional.

### Corrección de error `Invalid parameter number`

Durante la implementación inicial del hito 6 se detectó un error fatal en la página `pos.php` cuando se consultaban las variantes: `SQLSTATE[HY093]: Invalid parameter number`. Este error se producía porque en la función `getVariant()` se reutilizaba el parámetro nombrado `:lang` varias veces dentro de la misma consulta preparada, pero el driver PDO (con `ATTR_EMULATE_PREPARES` desactivado) no admite reutilizar el mismo marcador en varias posiciones sin proporcionar valores adicionales. Para resolverlo:

* Se modificó `getVariant()` para emplear **marcadores únicos para cada aparición de `id_lang`** en la consulta. En lugar de usar `:lang` repetidamente, ahora se utilizan `:lang_pl`, `:lang_al` y `:lang_ag` para las tablas `product_lang`, `attribute_lang` y `attribute_group_lang` respectivamente. Estas claves se pasan con el mismo valor de idioma.
* Se actualizó la ejecución del `PDOStatement` para incluir todos los parámetros necesarios en el array (`:lang_pl`, `:lang_al`, `:lang_ag`, `:attr`, `:pid`).

Con esta corrección se evita el error `Invalid parameter number` y se garantiza que la consulta de variantes funciona correctamente con el driver PDO configurado para no emular preparaciones. Esta modificación no altera la lógica de negocio, sino que asegura la compatibilidad con diferentes configuraciones de PHP.