<?php
require_once __DIR__ . '/includes/functions.php';
requireLogin();
requirePermission('dashboard', 'view');
require_once __DIR__ . '/layout.php';

$user = currentUser();
$username = $user['username'] ?? '';

// Obtener estadísticas básicas para el panel
$pdo = getPDO();
// Contadores con seguridad por si las tablas no existen
$totalUsers    = 0;
$totalRoles    = 0;
$totalBoxes    = 0;
$openSessions  = 0;
$totalSales    = 0;
if ($pdo) {
    try {
        $totalUsers   = (int)$pdo->query('SELECT COUNT(*) FROM users')->fetchColumn();
    } catch (Exception $e) {}
    try {
        $totalRoles   = (int)$pdo->query('SELECT COUNT(*) FROM roles')->fetchColumn();
    } catch (Exception $e) {}
    try {
        $totalBoxes   = (int)$pdo->query('SELECT COUNT(*) FROM boxes')->fetchColumn();
    } catch (Exception $e) {}
    try {
        $openSessions = (int)$pdo->query('SELECT COUNT(*) FROM cash_sessions WHERE closed_at IS NULL')->fetchColumn();
    } catch (Exception $e) {}
    try {
        $totalSales   = (int)$pdo->query('SELECT COUNT(*) FROM sales')->fetchColumn();
    } catch (Exception $e) {}
}

renderHeader('Inicio', 'dashboard');
?>
<div class="container-fluid">
    <div class="row align-items-center mb-4">
        <div class="col-md-8">
            <h1 class="h3 mb-0">Panel de Inicio</h1>
            <p class="text-muted mb-0">Bienvenido, <strong><?php echo escape($username); ?></strong>. Seleccione una opción en el menú para comenzar.</p>
        </div>
    </div>
    <div class="row g-3 mb-4">
        <!-- Tarjeta Usuarios -->
        <div class="col-sm-6 col-lg-4">
            <div class="card shadow-sm h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="me-3">
                        <span class="fs-2 text-primary"><i class="fas fa-users"></i></span>
                    </div>
                    <div>
                        <h6 class="mb-0 text-muted">Usuarios</h6>
                        <h4 class="fw-bold mb-0"><?php echo $totalUsers; ?></h4>
                    </div>
                </div>
            </div>
        </div>
        <!-- Tarjeta Roles -->
        <div class="col-sm-6 col-lg-4">
            <div class="card shadow-sm h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="me-3">
                        <span class="fs-2 text-primary"><i class="fas fa-user-tag"></i></span>
                    </div>
                    <div>
                        <h6 class="mb-0 text-muted">Roles</h6>
                        <h4 class="fw-bold mb-0"><?php echo $totalRoles; ?></h4>
                    </div>
                </div>
            </div>
        </div>
        <!-- Tarjeta Cajas -->
        <div class="col-sm-6 col-lg-4">
            <div class="card shadow-sm h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="me-3">
                        <span class="fs-2 text-primary"><i class="fas fa-cash-register"></i></span>
                    </div>
                    <div>
                        <h6 class="mb-0 text-muted">Cajas</h6>
                        <h4 class="fw-bold mb-0"><?php echo $totalBoxes; ?></h4>
                    </div>
                </div>
            </div>
        </div>
        <!-- Tarjeta Sesiones abiertas -->
        <div class="col-sm-6 col-lg-4">
            <div class="card shadow-sm h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="me-3">
                        <span class="fs-2 text-primary"><i class="fas fa-clock"></i></span>
                    </div>
                    <div>
                        <h6 class="mb-0 text-muted">Sesiones abiertas</h6>
                        <h4 class="fw-bold mb-0"><?php echo $openSessions; ?></h4>
                    </div>
                </div>
            </div>
        </div>
        <!-- Tarjeta Ventas -->
        <div class="col-sm-6 col-lg-4">
            <div class="card shadow-sm h-100">
                <div class="card-body d-flex align-items-center">
                    <div class="me-3">
                        <span class="fs-2 text-primary"><i class="fas fa-shopping-cart"></i></span>
                    </div>
                    <div>
                        <h6 class="mb-0 text-muted">Ventas registradas</h6>
                        <h4 class="fw-bold mb-0"><?php echo $totalSales; ?></h4>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Sección de acceso rápido -->
    <div class="row g-3">
        <div class="col-md-6 col-lg-4">
            <a href="pos.php" class="text-decoration-none">
                <div class="card h-100">
                    <div class="card-body text-center">
                        <span class="fs-1 text-primary"><i class="fas fa-shopping-cart"></i></span>
                        <h5 class="mt-2">Punto de Venta</h5>
                        <p class="text-muted small">Iniciar una nueva venta, buscar productos y cobrar de forma rápida.</p>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-md-6 col-lg-4">
            <a href="boxes.php" class="text-decoration-none">
                <div class="card h-100">
                    <div class="card-body text-center">
                        <span class="fs-1 text-primary"><i class="fas fa-cash-register"></i></span>
                        <h5 class="mt-2">Cajas</h5>
                        <p class="text-muted small">Gestiona la apertura y cierre de cajas, movimientos y sesiones.</p>
                    </div>
                </div>
            </a>
        </div>
        <div class="col-md-6 col-lg-4">
            <a href="settings.php" class="text-decoration-none">
                <div class="card h-100">
                    <div class="card-body text-center">
                        <span class="fs-1 text-primary"><i class="fas fa-cogs"></i></span>
                        <h5 class="mt-2">Configuraciones</h5>
                        <p class="text-muted small">Administra medios de pago, encabezados de tickets y otros ajustes.</p>
                    </div>
                </div>
            </a>
        </div>
    </div>
</div>
<?php
renderFooter();